VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 1  'vbDataSource
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsProductManager"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Enum TableName
  e_Customers = 0
  e_OrderDetails = 1
  e_Orders = 2
  e_Products = 3
  e_Shippers = 4
  e_Employees = 5
  e_Suppliers = 6
End Enum

Public Enum BOFActionType
  adMoveFirst = 0
  adStayBOF = 1
End Enum

Public Enum EOFActionType
  adMoveLast = 0
  adStayEOF = 1
  adAddNew = 2
End Enum

Private m_eRecordsetName As TableName
Private m_strWhereClause As String
Private m_strDataMember As String
Private m_strPrimaryKey As String
Private m_eBOFAction As BOFActionType
Private m_eEOFAction As EOFActionType
Private m_strUserName As String
Private m_strPassword As String
Private m_eEditMode As ADODB.EditModeEnum

Private WithEvents m_objManagedObject As clsProduct
Attribute m_objManagedObject.VB_VarHelpID = -1
Public Event ChangeManagedObjects()
Const m_def_BOFAction = BOFActionType.adMoveFirst
Const m_def_EOFAction = EOFActionType.adMoveLast
Const m_def_UserName = ""
Const m_def_Password = ""
Private m_objDataSpace As RDS.DataSpace
Private m_objProxy As clsServer

Private Sub Class_GetDataMember(DataMember As String, Data As Object)

  On Error GoTo GetDataMemberError

  If ItemsDataMember <> DataMember Then
     Exit Sub
  End If

  Set Data = m_objManagedObject.ItemsRecordset

  Exit Sub
GetDataMemberError:

  Set Data = Nothing

End Sub

Private Sub Class_Initialize()

  On Error GoTo IntitializeError

  Set m_objManagedObject = New clsProduct
  
'  GetProxy
  
  Set m_objProxy = New clsServer
  
  m_eBOFAction = m_def_BOFAction
  m_eEOFAction = m_def_EOFAction
  m_strUserName = m_def_UserName
  m_strPassword = m_def_Password
  m_eEditMode = adEditNone

  Exit Sub

IntitializeError:

  MsgBox "Collection Managing Class cannot be initialized"

End Sub

Public Sub GetProxy()
    
    Set m_objDataSpace = New RDS.DataSpace
    
    m_objDataSpace.InternetTimeout = 30000
        
    Set m_objProxy = m_objDataSpace.CreateObject _
   ("prjServer.clsServer", "")

End Sub


Private Sub Class_Terminate()

  If Not m_objManagedObject Is Nothing Then
     Set m_objManagedObject = Nothing
  End If

End Sub

Friend Function SetProxyInformation(ByVal v_eRecordsetName As TableName, _
     ByVal v_strWhereClause As String, ByVal v_strPrimaryKey As String, _
     ByVal v_eDataMember As String)

    m_eRecordsetName = v_eRecordsetName
    m_strWhereClause = v_strWhereClause
    m_strPrimaryKey = v_strPrimaryKey
    m_strDataMember = v_eDataMember
    m_objManagedObject.ItemsDataMember = v_eDataMember

End Function

Friend Property Get ItemsDataMember() As String

  ItemsDataMember = m_strDataMember

End Property
Private Property Get PrimaryKey() As String

  PrimaryKey = m_strPrimaryKey

End Property
Private Property Get RecordsetName() As TableName

  RecordsetName = m_eRecordsetName

End Property

Private Property Get WhereClause() As String

  WhereClause = m_strWhereClause

End Property
Public Property Get Item() As clsProduct

  Set Item = m_objManagedObject

End Property

Public Property Get ItemCount() As Long

  ItemCount = m_objManagedObject.ItemsRecordset.RecordCount

End Property


Friend Property Get ItemsRecordset() As ADODB.Recordset

  Set ItemsRecordset = m_objManagedObject.ItemsRecordset

End Property

Public Property Get EditMode() As ADODB.EditModeEnum

  EditMode = m_eEditMode

End Property

Friend Property Let EditMode(ByVal v_eNewEditMode As ADODB.EditModeEnum)

  m_eEditMode = v_eNewEditMode

  If m_objManagedObject.EditMode <> v_eNewEditMode Then
     m_objManagedObject.EditMode = v_eNewEditMode
  End If

End Property

Public Sub Refresh()

  Dim strPrimaryKeyValue As String 'Use to keep to current record
  If m_objManagedObject.ItemsRecordset.State = adStateOpen Then
     If Not m_objManagedObject.ItemsRecordset.BOF And _
        Not m_objManagedObject.ItemsRecordset.EOF And _
        Not IsNull(m_objManagedObject.ItemsRecordset.Fields(PrimaryKey)) Then
            strPrimaryKeyValue = _
      m_objManagedObject.ItemsRecordset.Fields(PrimaryKey)
     End If
  End If
  UpdateManagedObjects
  If strPrimaryKeyValue <> "" Then
      m_objManagedObject.ItemsRecordset.Find PrimaryKey & "='" & _
            strPrimaryKeyValue & "'", , , 1
  End If

End Sub
  
Public Sub Edit()

  If EditMode = adEditNone Then
     EditMode = adEditInProgress
  End If

End Sub
  
Public Sub Delete()

  On Error GoTo DeleteError
  If EditMode = adEditNone Then
    If EditMode = adEditNone Then
    m_objManagedObject.ItemsRecordset.Delete
        Set m_objManagedObject.ItemsRecordset = _
        m_objProxy.UpdateRecordset(UserName, Password, _
        m_objManagedObject.ItemsRecordset, m_eRecordsetName, WhereClause)
  Else
    GetErrorText "CanNotDeleteDuringEdit/AddNew"
    End If

  End If
  Exit Sub

DeleteError:

  Err.Raise Err.Number, "Delete " & Err.Source, Err.Description

End Sub
Public Sub AddNew()

  On Error GoTo AddNewError

  If EditMode = adEditNone Then
    m_objManagedObject.ItemsRecordset.AddNew
    EditMode = adEditAdd
  Else
        
  End If
  Exit Sub

AddNewError:

  Err.Raise Err.Number, "AddNew " & Err.Source, Err.Description

End Sub
Public Sub Cancel()

  If EditMode = adEditAdd Or EditMode = adEditInProgress Then
     ItemsRecordset.CancelUpdate
     EditMode = adEditNone
  End If

End Sub

Public Sub Update(ByVal v_blnSaveToDataBase As Boolean) 'CAB

  Dim lngPrimaryKeyValue As Long

  On Error GoTo UpdateError

  If ItemsRecordset.State = 1 And ItemsRecordset.EditMode = adEditInProgress Then

     If m_objManagedObject.ItemsRecordset.RecordCount <> 0 Then
            lngPrimaryKeyValue = _
                m_objManagedObject.ItemsRecordset.Fields(PrimaryKey)
     End If

  End If

  If EditMode <> adEditNone Then 'CAB

     If v_blnSaveToDataBase = False Then
        ItemsRecordset.Update
        RaiseEvent ChangeManagedObjects
    
        If lngPrimaryKeyValue <> 0 Then
            m_objManagedObject.ItemsRecordset.Find PrimaryKey & "='" & _
                   lngPrimaryKeyValue & "'"
        End If
    
        EditMode = adEditNone
        Exit Sub  'CAB to here
      
     Else

          m_objProxy.UpdateRecordset UserName, Password, _
             m_objManagedObject.ItemsRecordset, m_eRecordsetName, WhereClause
          EditMode = adEditNone
          RaiseEvent ChangeManagedObjects

     End If

  Else

  End If

  If lngPrimaryKeyValue <> 0 Then
     m_objManagedObject.ItemsRecordset.Find PrimaryKey & "='" & _
        lngPrimaryKeyValue & "'"
  End If

  If EditMode = adEditAdd Then
     m_objManagedObject.ItemsRecordset.MoveLast
  End If

  EditMode = adEditNone
  Exit Sub

UpdateError:

  Err.Raise Err.Number, "Update: " & Err.Source, Err.Description

End Sub
Public Function Find(ByVal v_strProductName As String)

  Dim strProductName As String

  If v_strProductName = "" Then
     Exit Function
  End If

 If InStr(v_strProductName, "'") > 0 Then
        strProductName = Mid(v_strProductName, 1, InStr(v_strProductName, "'") - 1)
  Else
        strProductName = v_strProductName
  End If

  ItemsRecordset.Find g_pFieldProductName & "= '" & strProductName & _
       "'", 0, adSearchForward, adBookmarkFirst
  Refresh

End Function

Public Property Get RecordCount() As Long

  RecordCount = m_objManagedObject.ItemsRecordset.RecordCount

End Property
Public Sub MoveFirst()

  On Error GoTo MoveFirstError

  If m_objManagedObject.ItemsRecordset Is Nothing Then
     Exit Sub
  End If

  If m_objManagedObject.ItemsRecordset.RecordCount > 0 Then
     m_objManagedObject.ItemsRecordset.MoveFirst
  End If

  Exit Sub

MoveFirstError:

  Err.Raise Err.Number, "Move First " & Err.Source, Err.Description

End Sub

Public Sub MoveLast()

  On Error GoTo MoveLastError

  If m_objManagedObject.ItemsRecordset Is Nothing Then
     Exit Sub
  End If

  If m_objManagedObject.ItemsRecordset.RecordCount > 0 Then
     m_objManagedObject.ItemsRecordset.MoveLast
  End If

  Exit Sub

MoveLastError:

  Err.Raise Err.Number, "Move Last " & Err.Source, Err.Description

End Sub
Public Sub MoveNext()

  On Error GoTo MoveNextError

  If m_objManagedObject.ItemsRecordset Is Nothing Then
     Exit Sub
  End If
  If m_objManagedObject.ItemsRecordset.EOF = False Then
     m_objManagedObject.ItemsRecordset.MoveNext
  End If
  If m_objManagedObject.ItemsRecordset.EOF = True Then
  
    Select Case EOFAction
        Case EOFActionType.adAddNew
             m_objManagedObject.ItemsRecordset.AddNew
        Case EOFActionType.adMoveLast
             m_objManagedObject.ItemsRecordset.MoveLast
        Case EOFActionType.adStayEOF
             Exit Sub
        Case Else
             Exit Sub
    End Select

  End If

  Exit Sub

MoveNextError:

  Err.Raise Err.Number, "Move Next " & Err.Source, Err.Description
    
End Sub
Private Sub MovePrevious()

  On Error GoTo MovePreviousError
 
  If m_objManagedObject.ItemsRecordset Is Nothing Then Exit Sub
   
  If m_objManagedObject.ItemsRecordset.BOF Then
     Select Case BOFAction
        Case BOFActionType.adMoveFirst
             m_objManagedObject.ItemsRecordset.MoveFirst
        Case BOFActionType.adStayBOF
             Exit Sub
        Case Else
             Exit Sub
     End Select

  Else
     m_objManagedObject.ItemsRecordset.MovePrevious

  End If

  Exit Sub

MovePreviousError:

  Err.Raise Err.Number, "Move Previous Error" & Err.Source, _
           Err.Description

End Sub
Private Sub UpdateManagedObjects()

  On Error GoTo UpdateManagedObjectsError

  Set m_objManagedObject.ItemsRecordset = _
         m_objProxy.ReturnProductsRecordSet(UserName, Password, WhereClause)
            
  DataMemberChanged ItemsDataMember

  m_objManagedObject.RefreshDataMember

  Exit Sub
     
UpdateManagedObjectsError:

  MsgBox Err.Description & Err.Source

End Sub
Public Property Get UserName() As String

  UserName = m_strUserName

End Property

Public Property Let UserName(ByVal New_strUserName As String)

  m_strUserName = New_strUserName

End Property

Public Property Get Password() As String

  Password = m_strPassword

End Property

Public Property Let Password(ByVal New_strPassword As String)

  m_strPassword = New_strPassword

End Property
Public Property Get BOFAction() As BOFActionType

  BOFAction = m_eBOFAction

End Property

Public Property Let BOFAction(ByVal New_BOFAction As BOFActionType)

  m_eBOFAction = New_BOFAction

End Property

Public Property Get EOFAction() As EOFActionType

  EOFAction = m_eEOFAction

End Property

Public Property Let EOFAction(ByVal New_EOFAction As EOFActionType)

  m_eEOFAction = New_EOFAction

End Property
  

Private Sub m_objManagedObject_EditInProgress(ByVal v_strEditMode As Variant)

  EditMode = v_strEditMode
  
End Sub

Private Sub m_objManagedObject_RefreshDataMember()

  DataMemberChanged ItemsDataMember
  
End Sub


